/*browser:true*/
/*global define*/

define([
  "jquery",
  "mage/storage",
  "Magento_Checkout/js/model/url-builder",
  "Magento_Customer/js/customer-data",
  window.checkoutConfig.revolutSdk,
], function ($, storage, urlBuilder, customerData, RevolutCheckout) {
  "use strict";
  $(`script[src="${window.checkoutConfig.revolutSdk}"]`).attr(
    "id",
    "revolut-checkout"
  );

  return {
    publicIdProduct: null,
    publicIdMiniCart: null,
    publicIdCart: null,
    paymentRequestProduct: null,
    paymentRequestMiniCart: null,
    paymentRequestCart: null,
    id_selected_carrier: null,
    redirect_url: null,
    widget_id: null,
    address_data: null,
    paymentRequestButtonParams: null,
    shippingOptions: [
      { id: "free_shipping", amount: "0", description: "", label: "-" },
    ],
    id_product_attribute: null,

    initCartPaymentRequestButton: function (cart_type) {
      const self = this;
      storage
        .post(urlBuilder.createUrl("/revolut/create/order", {}))
        .done(function (response) {
          let paymentRequestButtonParams = JSON.parse(response);
          if (paymentRequestButtonParams.success) {
            self.setPublicId(paymentRequestButtonParams.public_id, cart_type);
            self.createRevolutPaymentRequestButton(cart_type);
          }
        });
    },

    initProductPaymentRequestButton: function () {
      if (!window.checkoutConfig.id_product) {
        return false;
      }
      const self = this;
      storage
        .post(urlBuilder.createUrl("/revolut/create/order", {}))
        .done(function (response) {
          let paymentRequestButtonParams = JSON.parse(response);
          if (paymentRequestButtonParams.success) {
            self.setPublicId(paymentRequestButtonParams.public_id, "product");
            self.createRevolutPaymentRequestButton("product");
          }
        });
    },

    reCreateRevolutPaymentRequestButton: function (widget_id) {
      let paymentRequest = this.getPaymentRequest(widget_id);
      if (paymentRequest) {
        paymentRequest.destroy();
      }
      const self = this;
      storage
        .post(urlBuilder.createUrl("/revolut/create/order", {}))
        .done(function (response) {
          let paymentRequestButtonParams = JSON.parse(response);
          if (paymentRequestButtonParams.success) {
            self.setPublicId(paymentRequestButtonParams.public_id, widget_id);
            self.createRevolutPaymentRequestButton(widget_id);
          }
        });
    },

    createRevolutPaymentRequestButton: async function (widget_id) {
      if (!$(`#revolut-payment-request-button-${widget_id}`).length) {
        return;
      }

      $(`#revolut-payment-request-button-${widget_id}`)
        .empty()
        .append("<span></span>");

      const self = this;
      const RC = await RevolutCheckout(self.getPublicId(widget_id));
      let themeConfigs = window.checkoutConfig.themeConfigs;
      let paymentRequest = RC.paymentRequest({
        target: document.querySelector(
          `#revolut-payment-request-button-${widget_id} span`
        ),
        requestShipping: true,
        shippingOptions: self.shippingOptions,
        onClick() {},
        onShippingOptionChange: (selectedShippingOption) => {
          return self.setShippingOption(widget_id, selectedShippingOption);
        },
        onShippingAddressChange: (selectedShippingAddress) => {
          return self.addToCart(widget_id).then(() => {
            return self.loadShippingOptions(widget_id, selectedShippingAddress);
          });
        },
        onSuccess: () => {
          return self.processOrder(widget_id);
        },
        validate: (address) => {
          $("body").loader("show");
          return self.validateOrder(widget_id, address);
        },
        onError: (error) => {
          self.displayError(widget_id, error);
        },
        buttonStyle: themeConfigs,
      });

      paymentRequest.canMakePayment().then((result) => {
        if (result) {
          paymentRequest.render();
        } else {
          paymentRequest.destroy();
        }
      });

      this.setPaymentRequest(paymentRequest, widget_id);
    },

    setPublicId: function (publicId, widget_id) {
      switch (widget_id) {
        case "product":
          this.publicIdProduct = publicId;
          break;
        case "cart":
          this.publicIdCart = publicId;
          break;
        case "minicart":
          this.publicIdMiniCart = publicId;
          break;
        default:
          this.publicIdProduct = publicId;
      }
    },

    getPublicId: function (widget_id) {
      switch (widget_id) {
        case "product":
          return this.publicIdProduct;
          break;
        case "cart":
          return this.publicIdCart;
          break;
        case "minicart":
          return this.publicIdMiniCart;
          break;
        default:
          return this.publicIdProduct;
      }
    },

    setPaymentRequest: function (paymentRequest, widget_id) {
      switch (widget_id) {
        case "product":
          this.paymentRequestProduct = paymentRequest;
          break;
        case "cart":
          this.paymentRequestCart = paymentRequest;
          break;
        case "minicart":
          this.paymentRequestMiniCart = paymentRequest;
          break;
        default:
          this.paymentRequestProduct = paymentRequest;
      }
    },
    getPaymentRequest: function (widget_id) {
      switch (widget_id) {
        case "product":
          return this.paymentRequestProduct;
          break;
        case "cart":
          return this.paymentRequestCart;
          break;
        case "minicart":
          return this.paymentRequestMiniCart;
          break;
        default:
          return this.paymentRequestProduct;
      }
    },
    loadShippingOptions: function (widget_id, address) {
      const self = this;
      return new Promise((resolve, reject) => {
        self.address_data = {
          country: address.country,
          state: address.region,
          postcode: address.postalCode,
          city: address.city,
          address: "",
          address_2: "",
        };

        storage
          .post(
            urlBuilder.createUrl("/revolut/prb/shippingoptions/load", {}),
            JSON.stringify({
              address_data: self.address_data,
              revolut_public_id: self.getPublicId(widget_id),
            }),
            true
          )
          .done(function (response) {
            response = JSON.parse(response);
            if (
              response.shippingOptions &&
              response.shippingOptions.length > 0
            ) {
              self.id_selected_carrier = response.shippingOptions[0].id;
            }
            resolve(response);
          });
      });
    },

    setShippingOption: function (widget_id, selected_carrier) {
      const self = this;
      return new Promise((resolve, reject) => {
        self.id_selected_carrier = selected_carrier.id;

        storage
          .post(
            urlBuilder.createUrl("/revolut/prb/shippingoptions/set", {}),
            JSON.stringify({
              address_data: self.address_data,
              id_selected_carrier: self.id_selected_carrier,
              revolut_public_id: self.getPublicId(widget_id),
            }),
            true
          )
          .done(function (response) {
            response = JSON.parse(response);
            resolve(response);
          });
      });
    },

    addToCart: function (widget_id) {
      return new Promise((resolve, reject) => {
        if (widget_id == "cart" || widget_id == "minicart") {
          return resolve([]);
        }
        const self = this;
        const form = jQuery("#product_addtocart_form");

        var validator = form.validation({ radioCheckboxClosest: ".nested" });

        if (!validator.valid()) {
          reject("Invalid form");
          return self.displayError(widget_id, "Invalid form");
        }

        const req = form.serialize();
        storage
          .post(
            urlBuilder.createUrl("/revolut/prb/addtocart", {}),
            JSON.stringify({
              request: req,
              id_carrier: self.id_selected_carrier,
            }),
            true
          )
          .done(function (response) {
            response = JSON.parse(response);
            customerData.invalidate(["cart"]);
            customerData.reload(["cart"], true);
            resolve(response);
          });
      });
    },

    validateOrder: function (widget_id, address) {
      const self = this;

      return new Promise((resolve, reject) => {
        storage
          .post(
            urlBuilder.createUrl("/revolut/prb/validate/order", {}),
            JSON.stringify({
              public_id: self.getPublicId(widget_id),
              address: address,
              id_carrier: self.id_selected_carrier,
            }),
            true
          )
          .done(function (response) {
            response = JSON.parse(response);

            if (response.success) {
              return resolve(response);
            }

            reject(response.message);
            self.displayError(widget_id, response.message);
          });
      });
    },

    processOrder: function (widget_id) {
      const self = this;

      return new Promise((resolve, reject) => {
        storage
          .post(
            urlBuilder.createUrl("/revolut/prb/process/order", {}),
            JSON.stringify({}),
            true
          )
          .done(function (response) {
            response = JSON.parse(response);

            if (response.success) {
              window.location.href = response.redirect_url;
              return;
            }
            self.cancelPayment(widget_id, false);
            self.displayError(widget_id, response.message);
          })
          .fail(function (response) {
            self.cancelPayment(
              widget_id,
              "An error occured while processing your order."
            );
          });
      });
    },

    cancelPayment: function (widget_id, errorMsg) {
      const self = this;
      storage
        .post(
          urlBuilder.createUrl("/revolut/cancel/order", {}),
          JSON.stringify({
            revolut_public_id: self.getPublicId(widget_id),
          }),
          true
        )
        .done(function () {
          if (errorMsg) {
            self.displayError(widget_id, errorMsg);
          }
        });
    },

    displayError: function (widget_id, message) {
      this.reCreateRevolutPaymentRequestButton(widget_id);
      $("body").loader("hide");
      alert(message);
    },
  };
});
