/*browser:true*/
/*global define*/

define([
  "jquery",
  "Revolut_Payment/js/view/payment/method-renderer/revolut-payment-component-core",
  "Magento_Checkout/js/model/full-screen-loader",
  "ko",
  "Magento_Checkout/js/model/quote",
  window.checkoutConfig.payment.revolut_form.revolutSdk,
], function ($, Component, fullScreenLoader, ko, quote, RevolutCheckout) {
  "use strict";
  return Component.extend({
    defaults: {
      template: "Revolut_Payment/payment/revolut-pay-form",
      revolutSdk: window.checkoutConfig.payment.revolut_form.revolutSdk,
      revolutPay: ko.observable(null),
      errorWidgetTarget: "#show-error-pay-error",
    },

    createRevolutWidgetInstance: function (response) {
      response = JSON.parse(response);

      if (!response.success) {
        $("#revolutForm").hide();
        this.errorCreateRevolutOrder(response.mess);
        this.messageContainer.addErrorMessage({
          message: $.mage.__(response.mess),
        });
        fullScreenLoader.stopLoader();
        return;
      }

      if (this.publicKey()) {
        return this.createRevolutPayV2Instance();
      }

      this.createRevolutPayV1Instance();
    },

    createRevolutPayV1Instance: function () {
      let payInstance = this.revolutPay();
      let self = this;

      if (payInstance !== null) {
        payInstance.destroy();
      }

      payInstance = RevolutCheckout(this.publicId()).revolutPay({
        target: document.getElementById("revolut-pay-element"),
        locale: window.checkoutConfig.payment.revolut_form.locale,
        phone: self.getBillingPhone(),
        onSuccess() {
          self.handleSuccess();
        },
        onError(messages) {
          self.handleError(messages);
        },
        validate() {
          return self.handleValidate();
        },
        onCancel() {
          self.handleCancel();
        },
        buttonStyle: {
          radius: "none",
          height: "45px",
        },
      });

      self.revolutPay(payInstance);
      fullScreenLoader.stopLoader();
    },

    createRevolutPayV2Instance: function () {
      let payInstance = this.revolutPay();
      let self = this;

      if (payInstance !== null) {
        payInstance.destroy();
      }

      payInstance = RevolutCheckout.payments({
        locale: window.checkoutConfig.payment.revolut_form.locale,
        publicToken: this.publicKey(),
      });

      const paymentOptions = {
        currency: self.paymentCurrency(),
        totalAmount: parseInt(self.paymentAmount()),
        validate: () => {
          return self.handleValidate();
        },
        createOrder: () => {
          return { publicId: self.publicId() };
        },
        metadata: {
          environment: "magento",
          context: "checkout",
          origin_url: window.checkoutConfig.payment.revolut_form.originUrl,
        },
        buttonStyle: {
          cashbackCurrency: self.paymentCurrency(),
          radius: "none",
          height: "50px",
        },
      };

      payInstance.revolutPay.mount(document.getElementById("revolut-pay-element"), paymentOptions);

      payInstance.revolutPay.on("payment", function (event) {
        switch (event.type) {
          case "success":
            self.handleSuccess();
            break;
          case "error":
            self.handleError({
              message: [event.error.message].filter(Boolean).join(" "),
            });
            break;
          case "cancel":
            self.handleCancel();
            break;
        }
      });

      self.revolutPay(payInstance);
      fullScreenLoader.stopLoader();
    },

    getCode: function () {
      return "revolut_pay_form";
    },
  });
});
