/*browser:true*/
/*global define*/

define([
  "jquery",
  "Revolut_Payment/js/view/payment/method-renderer/revolut-payment-component-core",
  "Magento_Checkout/js/model/full-screen-loader",
  "ko",
  window.checkoutConfig.payment.revolut_form.revolutSdk,
], function ($, Component, fullScreenLoader, ko, RevolutCheckout) {
  "use strict";
  return Component.extend({
    defaults: {
      template: "Revolut_Payment/payment/revolut-form",
      showPostCode: window.checkoutConfig.payment.revolut_form.showPostCode,
      revolutCard: ko.observable(null),
      errorWidgetTarget: "#show-error-card-error",
    },

    createRevolutWidgetInstance: function (response) {
      response = JSON.parse(response);

      if (!response.success) {
        $("#revolutForm").hide();
        this.errorCreateRevolutOrder(response.mess);
        this.messageContainer.addErrorMessage({
          message: $.mage.__(response.mess),
        });
        fullScreenLoader.stopLoader();
        return;
      }

      let cardInstance = this.revolutCard();
      let self = this;

      if (cardInstance !== null) {
        cardInstance.destroy();
      }

      cardInstance = RevolutCheckout(this.publicId()).createCardField({
        target: document.getElementById("revolut-card-element"),
        hidePostcodeField: self.showPostCode,
        locale: window.checkoutConfig.payment.revolut_form.locale,
        onSuccess() {
          self.handleSuccess();
        },
        onError(messages) {
          self.handleError(messages);
        },
        onValidation(messages) {
          self.handleError(messages);
        },
        onCancel() {
          self.handleCancel();
        },
      });

      this.revolutCard(cardInstance);
      fullScreenLoader.stopLoader();
    },

    getCode: function () {
      return "revolut_form";
    },
  });
});
