<?php

namespace Revolut\Payment\Plugin\View;

use Magento\Framework\View\Asset\Minification;

/**
 * Class PreventMinJs
 *
 * @package Revolut\Payment\Plugin\View
 */
class PreventMinJs
{
    /**
     * @param  Minification $subject
     * @param  array        $excludes
     * @param  string       $contentType
     * @return array
     */
    public function afterGetExcludes($subject, $excludes, $contentType)
    {
        if ($contentType !== 'js') {
            return $excludes;
        }

        $excludes[] = 'https://sandbox-merchant.revolut.com/embed.js';
        $excludes[] = 'https://merchant.revolut.com/embed.js';
        return $excludes;
    }
}
