<?php

namespace Revolut\Payment\Model\Ui;

use Magento\Checkout\Model\ConfigProviderInterface;
use Revolut\Payment\Model\RevolutForm;
use Revolut\Payment\Model\ConstantValue;
use Revolut\Payment\Helper\ConfigHelper;
use Revolut\Payment\Model\Source\Mode;
use Magento\Framework\Locale\Resolver;

/**
 * Class ConfigProvider
 *
 * @package Revolut\Payment\Model\Ui
 */
class ConfigProvider implements ConfigProviderInterface
{
    /**
     *
     */
    const CODE = RevolutForm::CODE;

    /**
     * @var ConfigHelper
     */
    protected $configHelper;
    
    /**
     * @var Resolver
     */
    protected $localeResolver;

    /**
     * ConfigProvider constructor.
     *
     * @param ConfigHelper $configHelper
     */
    public function __construct(
        ConfigHelper $configHelper,
        Resolver $localeResolver
    ) {
        $this->configHelper = $configHelper;
        $this->localeResolver = $localeResolver;
    }

    /**
     * @return array
     */
    public function getConfig()
    {
        $mode = $this->configHelper->getMode() == Mode::PRODUCTION_MODE ? ConstantValue::PROD_MODE : ConstantValue::SANDBOX_MODE;
        return [
            'payment' => [
                self::CODE => [
                    'mode' => $mode,
                    'originUrl' => $this->getStoreDomain(),
                    'locale' => $this->getStoreLocale(),
                    'revolutSdk' => ConstantValue::REVOLUT_SDK_URLS[$mode],
                    'prbButtonThemeConfigs' => $this->configHelper->getPaymentRequestButtonThemeConfigs(),
                    'showPostCode' => $this->configHelper->getConfigValue(ConfigHelper::SHOW_POST_CODE) ? true : false
                ]
            ]
        ];
    }

    /**
     * @return string|false store locale
     */
    public function getStoreLocale()
    {
        $currentLocaleCode = $this->localeResolver->getLocale(); // en_EN
        return strstr($currentLocaleCode, '_', true);
    }
    
    /**
     * @return string|false store domain
     */
    public function getStoreDomain()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $storeManager = $objectManager->create("\Magento\Store\Model\StoreManagerInterface");
        // @phpstan-ignore-next-line
        $mageDomain = parse_url($storeManager->getStore()->getBaseUrl());
        
        if (empty($mageDomain)) {
            return '';
        }

        return $mageDomain['host'];
    }
}
