<?php

namespace Revolut\Payment\Model;

/**
 * Class RevolutPayForm
 *
 * @package Revolut\Payment\Model
 */
class RevolutPaymentRequestForm extends RevolutAbstractPaymentMethod
{
    const CODE = 'revolut_payment_request_form';
    protected $_code = self::CODE;

     /**
      * Retrieve payment method title
      *
      * @return string
      */
    public function getTitle()
    {
        $defaultTittle = 'Apple Pay / Google Pay (via Revolut)';

        try {
            $info = $this->getInfoInstance();
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            return  $defaultTittle;
        }

        try {
            // @phpstan-ignore-next-line
            if (!$info) {
                return $defaultTittle;
            }
    
            $order = $info->getOrder();
    
            if (!$order) {
                return  $defaultTittle;
            }
    
            $id_quote = $order->getQuoteId();
            $revolutOrderFactory = $this->revolutOrderFactory->create();
            $revolutOrder = $revolutOrderFactory->getRevolutOrder($id_quote, 'quote_id');
            $revolutOrderId = $revolutOrder->getData('revolut_order_id');
    
            if (empty($revolutOrderId)) {
                return  $defaultTittle;
            }
    
            $revolutOrder = $this->dataHelper->getRevolutOrder($revolutOrderId);
        
            if (!isset($revolutOrder['id'])) {
                return  $defaultTittle;
            }
            
            if (! isset($revolutOrder['payments'][0]['payment_method']['type']) || empty($revolutOrder['payments'][0]['payment_method']['type'])) {
                return  $defaultTittle;
            }
    
            $paymentMethod = $revolutOrder['payments'][0]['payment_method']['type'];
    
            if ('APPLE_PAY' === $paymentMethod) {
                $paymentMethodTitle = 'Apple Pay (via Revolut)';
            } elseif ('GOOGLE_PAY' === $paymentMethod) {
                $paymentMethodTitle = 'Google Pay (via Revolut)';
            } else {
                $paymentMethodTitle =  $defaultTittle;
            }
    
            return $paymentMethodTitle;
        } catch (\Exception $e) {
            return  $defaultTittle;
        }
    }

    /**
     * @param  \Magento\Quote\Api\Data\CartInterface|null $quote
     * @return bool
     */
    public function isAvailable(\Magento\Quote\Api\Data\CartInterface $quote = null)
    {
        if (!$this->moduleManager->isEnabled(ConstantValue::MODULE_NAME) || !\Magento\Payment\Model\Method\AbstractMethod::isAvailable($quote)) {
            return false;
        }

        return $this->configHelper->isPaymentRequestButtonAvailableFor('checkout');
    }
}
