<?php

namespace Revolut\Payment\Model;

/**
 * Class RevolutPayForm
 *
 * @package Revolut\Payment\Model
 */
class RevolutPayForm extends RevolutAbstractPaymentMethod
{
    const CODE = 'revolut_pay_form';
    protected $_code = self::CODE;

     /**
      * Retrieve payment method title
      *
      * @return string
      */
    public function getTitle()
    {
        return 'Revolut Pay - Get Cashback';
    }

    /**
     * @param  \Magento\Quote\Api\Data\CartInterface|null $quote
     * @return bool
     */
    public function isAvailable(\Magento\Quote\Api\Data\CartInterface $quote = null)
    {
        if (!$this->moduleManager->isEnabled(ConstantValue::MODULE_NAME) || !\Magento\Payment\Model\Method\AbstractMethod::isAvailable($quote)) {
            return false;
        }

        return $this->configHelper->revolutPayIsAvailable();
    }
}
