<?php

namespace Revolut\Payment\Model;

use Magento\Framework\Model\AbstractModel;

/**
 * Class RevolutOrder
 *
 * @package Revolut\Payment\Model
 */
class RevolutOrder extends AbstractModel
{
    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $customerSession;

    /**
     * @var ResourceModel\RevolutOrder
     */
    protected $revolutOrderResource;

    /**
     * RevolutOrder constructor.
     *
     * @param \Magento\Framework\Model\Context                             $context
     * @param \Magento\Framework\Registry                                  $registry
     * @param \Magento\Customer\Model\Session                              $customerSession
     * @param ResourceModel\RevolutOrder                                   $revolutOrderResource
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource|null $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb|null           $resourceCollection
     * @param array                                                        $data
     */
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Customer\Model\Session $customerSession,
        \Revolut\Payment\Model\ResourceModel\RevolutOrder $revolutOrderResource,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->customerSession = $customerSession;
        $this->revolutOrderResource = $revolutOrderResource;
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     *
     */
    public function _construct()
    {
        $this->_init('Revolut\Payment\Model\ResourceModel\RevolutOrder');
    }

    /**
     * @param  $orderData
     * @throws \Exception
     * @param  array     $orderData
     * @return void
     */
    public function saveRevolutOrder($orderData)
    {
        $revolutOrder = $this;
        $customerId = $this->customerSession->getId();
        $data = [
            'customer_id' => $customerId,
            'revolut_order_id' => $orderData['id'],
            'public_id' => $orderData['public_id'],
            'currency' => $orderData['order_amount']['currency'],
            'order_amount' => $orderData['order_amount']['value'],
            'quote_id' => $orderData['quote_id'],
            'increment_order_id' => ''
        ];
        $revolutOrder->setData($data);
        try {
            $this->revolutOrderResource->save($revolutOrder);
        } catch (\Exception $e) {
            throw new \Exception(__($e->getMessage()));
        }
    }

    /**
     * @param  $orderAmount
     * @throws \Exception
     * @param  \Revolut\Payment\Model\RevolutOrder $revolutOrder
     * @param  array                               $data
     * @return void
     */
    public function updateRevolutOrder($revolutOrder, $data)
    {
        $revolutOrder->addData($data);
        try {
            $this->revolutOrderResource->save($revolutOrder);
        } catch (\Exception $e) {
            throw new \Exception(__($e->getMessage()));
        }
    }

    /**
     * @param  $orderData
     * @param  \Revolut\Payment\Model\RevolutOrder $revolutOrder
     * @param  string                              $field
     * @param  mixed                               $value
     * @throws \Exception
     * @return void
     */
    public function updateRevolutOrderField($revolutOrder, $field, $value)
    {
        $data = [$field => $value];
        $revolutOrder->addData($data);
        try {
            $this->revolutOrderResource->save($revolutOrder);
        } catch (\Exception $e) {
            throw new \Exception(__($e->getMessage()));
        }
    }

    /**
     * @param  $quoteId
     * @param  string|mixed $fieldValue
     * @param  string|null  $fieldName
     * @return \Revolut\Payment\Model\RevolutOrder
     */
    public function getRevolutOrder($fieldValue, $fieldName)
    {
        $revolutOrder = $this;
        $this->revolutOrderResource->load($revolutOrder, $fieldValue, $fieldName);
        return $revolutOrder;
    }
}
