<?php

namespace Revolut\Payment\Model;

/**
 * Class RevolutForm
 *
 * @package Revolut\Payment\Model
 */
class RevolutForm extends RevolutAbstractPaymentMethod
{
    const CODE = 'revolut_form';
    protected $_code = self::CODE;

    /**
     * @param  \Magento\Quote\Api\Data\CartInterface|null $quote
     * @return bool
     */
    public function isAvailable(\Magento\Quote\Api\Data\CartInterface $quote = null)
    {
        if (!$this->moduleManager->isEnabled(ConstantValue::MODULE_NAME) || !\Magento\Payment\Model\Method\AbstractMethod::isAvailable($quote)) {
            return false;
        }

        return $this->configHelper->cardPaymentsIsAvailable();
    }
}
