<?php

namespace Revolut\Payment\Model;

class ConstantValue
{
    const MODULE_NAME = 'Revolut_Payment';
    const URL_SANDBOX = 'https://sandbox-merchant.revolut.com';
    const URL_PROD = 'https://merchant.revolut.com';
    const MGMT_URL_SANDBOX = 'https://sandbox-merchant-mgmt.revolut.com';
    const MGMT_URL_PROD = 'https://merchant-mgmt.revolut.com';
    const MAGE_URI_WEBHOOK = 'revolut/webhook/updateorder';
    const API = '/api';
    const API_VER = '/api/1.0';
    const AUTO_CANCEL_TIMEOUT = 'PT2M';
    const ENDPOINT_PUBLIC_KEY = 'public-key/latest';
    const ENDPOINT_CASHBACK = 'cashback';
    const ENDPOINT_FEATURES = 'public/merchant';
    const USE_REVOLUT_PAY_2_0 = 'USE_REVOLUT_PAY_2_0';
    const ENDPOINT_ORDER = 'orders';
    const ENDPOINT_CAPTURE_ORDER = 'capture';
    const ENDPOINT_CANCEL_ORDER = 'cancel';
    const ENDPOINT_REFUND_ORDER = 'refund';
    const ENDPOINT_WEBHOOK = 'webhooks';
    const SANDBOX_MODE = 'sandbox';
    const PROD_MODE = 'prod';
    const REVOLUT_AUTHORIZE_ONLY = 'MANUAL';
    const REVOLUT_AUTHORIZE_CAPTURE = 'AUTOMATIC';
    const MAGENTO_AUTHORIZE = 'authorize';
    const MAGENTO_AUTHORIZE_CAPTURE = 'authorize_capture';
    const ORDER_COMPLETED = 'COMPLETED';
    const ORDER_AUTHORISED = 'AUTHORISED';
    const ORDER_IN_SETTLEMENT= 'IN_SETTLEMENT';
    const ORDER_CANCELLED = 'CANCELLED';
    const WEBHOOK_EVENT_ORDER_COMPLETED = 'ORDER_COMPLETED';

    const REVOLUT_SDK_URLS = [
        'sandbox' => "https://sandbox-merchant.revolut.com/embed.js",
        'prod' => "https://merchant.revolut.com/embed.js",
        'dev' => "https://merchant.revolut.codes/embed.js"
    ];

    //error code
    const FAILED_CARD = 2005;

    //state revolut order
    const STATE_COMPLETED = 'COMPLETED';

    const SUPPORTED_CURRENCIES = array('AED','AUD','BGN','BHD','CAD','CHF','CZK','DKK','EUR','GBP','HKD','HUF','ISK','JPY','KWD','NOK','NZD','OMR','PLN','QAR','RON','SAR','SEK','SGD','TRY','UAH','USD','ZAR');
    const SUPPORT_LINK = 'https://www.revolut.com/en-HR/business/help/merchant-accounts/payments/in-which-currencies-can-i-accept-payments';
}
