<?php

namespace Revolut\Payment\Model\Api;

use http\Env\Request;
use Revolut\Payment\Api\FrontLogHandlerInterface;
use Revolut\Payment\Helper\Logger;

/**
 * Class FrontLogHandler
 *
 * @package Revolut\Payment\Model\Api
 */
class FrontLogHandler implements FrontLogHandlerInterface
{
    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    protected $jsonHelper;

    /**
     * @var \Magento\Framework\Webapi\Rest\Request
     */
    protected $request;

    /**
     * @var Logger
     */
    protected $loggerRevolut;

        /**
         * FrontLogHandler constructor.
         *
         * @param \Magento\Framework\Json\Helper\Data    $jsonHelper
         * @param \Magento\Framework\Webapi\Rest\Request $request
         * @param \Revolut\Payment\Helper\Logger         $loggerRevolut
         */
    public function __construct(
        \Magento\Framework\Json\Helper\Data      $jsonHelper,
        \Magento\Framework\Webapi\Rest\Request  $request,
        \Revolut\Payment\Helper\Logger          $loggerRevolut
    ) {
        $this->jsonHelper = $jsonHelper;
        $this->request = $request;
        $this->loggerRevolut = $loggerRevolut;
    }

    /**
     * Save FE related errors
     *
     * @api
     * @return void.
     */
    public function handleLog()
    {
        $this->loggerRevolut->debug("========== checkout order create error trace begin  ========== ");
        $this->loggerRevolut->error($this->jsonHelper->jsonEncode($this->request->getBodyParams()));
        $this->loggerRevolut->debug("========== trace end ==========");
    }
}
