<?php

namespace Revolut\Payment\Controller\Webhook;

use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\Request\InvalidRequestException;

/**
 * Class UpdateOrder
 *
 * @package Revolut\Payment\Controller\Webhook
 */
class UpdateOrder extends RevolutWebhookController implements CsrfAwareActionInterface
{
    /**
     * @inheritDoc
     */
    public function createCsrfValidationException(
        RequestInterface $request
    ): ?InvalidRequestException {
        return null;
    }

    /**
     * @inheritDoc
     */
    public function validateForCsrf(RequestInterface $request): ?bool
    {
        //CSRF protection disabled because the Controller is a webhook that expect a request from Revolut.
        //https://devdocs.magento.com/guides/v2.4/extension-dev-guide/security/csrf.html#exceptions
        return true;
    }
}
