<?php

namespace Revolut\Payment\Controller\Adminhtml\Config;

use Magento\Backend\App\Action;
use Revolut\Payment\Model\ConstantValue;

/**
 * Class Webhook
 *
 * @package Revolut\Payment\Controller\Adminhtml\Config
 */
class Webhook extends Action
{
    /**
     * @var \Revolut\Payment\Helper\ConfigHelper
     */
    protected $configHelper;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Revolut\Payment\Helper\DataHelper
     */
    protected $dataHelper;

    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    protected $jsonHelper;

    /**
     * @var \Magento\Framework\Controller\ResultFactory
     */
    protected $resultFactory;

    /**
     * Webhook constructor.
     *
     * @param Action\Context                              $context
     * @param \Revolut\Payment\Helper\ConfigHelper        $configHelper
     * @param \Magento\Store\Model\StoreManagerInterface  $storeManager
     * @param \Revolut\Payment\Helper\DataHelper          $dataHelper
     * @param \Magento\Framework\Json\Helper\Data         $jsonHelper
     * @param \Magento\Framework\Controller\ResultFactory $resultFactory
     */
    public function __construct(
        Action\Context $context,
        \Revolut\Payment\Helper\ConfigHelper $configHelper,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Revolut\Payment\Helper\DataHelper $dataHelper,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        \Magento\Framework\Controller\ResultFactory $resultFactory
    ) {
        $this->configHelper = $configHelper;
        $this->storeManager = $storeManager;
        $this->dataHelper = $dataHelper;
        $this->jsonHelper = $jsonHelper;
        $this->resultFactory = $resultFactory;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function execute()
    {
        $webhookResult = $this->setWebHook();

        $data = [
            'error' => true,
        ];

        if ($webhookResult) {
            $data = [
                'success' => true,
            ];
        }

        $result = $this->resultFactory->create('json');
        return $result->setData($data);
    }

    /**
     * @return bool
     */
    public function setWebHook()
    {
        $mageWebHookUrl = $this->storeManager->getStore()->getBaseUrl() . ConstantValue::MAGE_URI_WEBHOOK;
        $isTest = $this->getRequest()->getParam('isTest');
        $apiKeyDataPost = $this->getRequest()->getParam('apiKey');
        // @phpstan-ignore-next-line
        $apiKey = strpos($apiKeyDataPost, '***') !== false ? null : $apiKeyDataPost;

        return $this->dataHelper->setRevolutWebhook($mageWebHookUrl, $apiKey, $isTest);
    }
}
