<?php

namespace Revolut\Payment\Controller\Adminhtml\Config;

use Magento\Backend\App\Action;

/**
 * Class DownloadDebug
 *
 * @package Revolut\Payment\Controller\Adminhtml\Config
 */
class DownloadDebug extends Action
{
    /**
     * @var \Magento\Framework\App\Filesystem\DirectoryList
     */
    protected $directoryList;

    /**
     * @var \Magento\Framework\Filesystem\Driver\File
     */
    protected $fileDriver;

    /**
     * @var \Magento\Framework\App\Response\Http\FileFactory
     */
    protected $fileFactory;

    /**
     * DownloadDebug constructor.
     *
     * @param \Magento\Framework\App\Response\Http\FileFactory $fileFactory
     * @param \Magento\Framework\Filesystem\Driver\File        $fileDriver
     * @param \Magento\Framework\App\Filesystem\DirectoryList  $directoryList
     * @param Action\Context                                   $context
     */
    public function __construct(
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Magento\Framework\Filesystem\Driver\File $fileDriver,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList,
        Action\Context $context
    ) {
        $this->fileFactory = $fileFactory;
        $this->fileDriver = $fileDriver;
        $this->directoryList = $directoryList;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Redirect|\Magento\Framework\Controller\ResultInterface
     * @throws \Magento\Framework\Exception\FileSystemException
     */
    public function execute()
    {
        $version = $this->getRequest()->getParam('version');
        $filename = "revolut_log_file_" . $version . "_" . date("Ymd") . ".log";
        $file = $this->directoryList->getPath("var") . "/log/revolut/debug.log";
        if ($this->fileDriver->isExists($file)) {
            // @phpstan-ignore-next-line
            return $this->fileFactory->create($filename, file_get_contents($file), "tmp");
        }
        $resultRedirect = $this->resultRedirectFactory->create();
        $this->messageManager->addError(__('Debug File Does Not Exist'));
        return $resultRedirect->setPath('*/*/');
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Revolut_Payment::settings');
    }
}
