<?php

namespace Revolut\Payment\Block\System\Config;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Revolut\Payment\Model\ConstantValue;

/**
 * Class Webhook
 *
 * @package Revolut\Payment\Block\System\Config
 */
class WebhookSandbox extends Field
{
    /**
     * @var string
     */
    protected $_template = 'Revolut_Payment::system/config/webhook_button_sandbox.phtml';

    /**
     * @var \Revolut\Payment\Helper\ConfigHelper
     */
    protected $configHelper;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Revolut\Payment\Helper\DataHelper
     */
    protected $dataHelper;

    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    protected $jsonHelper;

    /**
     * Webhook constructor.
     *
     * @param Context $context
     * @param array   $data
     */
    public function __construct(
        Context $context,
        \Revolut\Payment\Helper\ConfigHelper $configHelper,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Revolut\Payment\Helper\DataHelper $dataHelper,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        array $data = []
    ) {
        $this->configHelper = $configHelper;
        $this->storeManager = $storeManager;
        $this->dataHelper = $dataHelper;
        $this->jsonHelper = $jsonHelper;
        parent::__construct($context, $data);
    }

    /**
     * @param  AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * @param  AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        return $this->_toHtml();
    }

    /**
     * @return mixed
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getButtonHtml()
    {
        $button = $this->getLayout()->createBlock(
            'Magento\Backend\Block\Widget\Button'
        )->setData(
            [
                'id' => 'webhook-config',
                'label' => __('Setup Webhook'),
            ]
        );
        return $button->toHtml();
    }

    /**
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function checkSetupWebhook()
    {
        $mageWebHookUrl = $this->storeManager->getStore()->getBaseUrl() . ConstantValue::MAGE_URI_WEBHOOK;
        return $this->dataHelper->checkRevolutWebhookSetup($mageWebHookUrl, true);
    }
}
