<?php

namespace Revolut\Payment\Block\System\Config;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Data\Form\Element\AbstractElement;

/**
 * Class Webhook
 *
 * @package Revolut\Payment\Block\System\Config
 */
class DownloadLogFile extends Field
{
    /**
     * @var string
     */
    protected $_template = 'Revolut_Payment::system/config/download_log_file.phtml';

    /**
     * @var \Revolut\Payment\Helper\ConfigHelper
     */
    protected $configHelper;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Revolut\Payment\Helper\DataHelper
     */
    protected $dataHelper;

    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    protected $jsonHelper;
    
    /**
     * @var \Magento\Framework\Module\ModuleListInterface
     */
    protected $moduleList;

    /**
     * Webhook constructor.
     *
     * @param Context $context
     * @param array   $data
     */
    public function __construct(
        Context $context,
        \Revolut\Payment\Helper\ConfigHelper $configHelper,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Revolut\Payment\Helper\DataHelper $dataHelper,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        \Magento\Framework\Module\ModuleListInterface $moduleList,
        array $data = []
    ) {
        $this->configHelper = $configHelper;
        $this->storeManager = $storeManager;
        $this->dataHelper = $dataHelper;
        $this->jsonHelper = $jsonHelper;
        $this->moduleList = $moduleList;
        parent::__construct($context, $data);
    }

    /**
     * @param  AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * @param  AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        return $this->_toHtml();
    }

    /**
     * @return mixed
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getButtonHtml()
    {
        $button = $this->getLayout()->createBlock(
            'Magento\Backend\Block\Widget\Button'
        )->setData(
            [
                'id' => 'download-log-file',
                'label' => __('Download log file'),
            ]
        );
        return $button->toHtml();
    }

     /**
      * @return mixed
      */
    public function getDownloadDebugUrl()
    {
        return $this->getUrl('revolut/config/downloadDebug', ['version' => $this->getVersion()]);
    }

    /**
     * @return mixed
     */
    public function getVersion()
    {
        return $this->moduleList->getOne('Revolut_Payment')['setup_version']; // @phpstan-ignore-line
    }
}
