<?php

namespace Revolut\Payment\Block\PaymentRequest;

use Magento\Catalog\Block\ShortcutInterface;

class PaymentRequestButtonBlock extends PaymentRequestButton implements ShortcutInterface
{
    /**
     * @var string
     */
    protected $_template = 'Revolut_Payment::prbutton/minicart.phtml';

    /**
     * @var bool
     */
    public $isCatalogPage = false;
    
    /**
     * @var bool
     */
    public $isShoppingCart = false;

    /**
     * @return mixed.
     */
    public function getAlias()
    {
        return $this->getData("alias");
    }

    /**
     * @param  bool $isCatalogPage
     * @return $this
     */
    public function setIsInCatalogProduct($isCatalogPage)
    {
        $this->isCatalogPage = !$isCatalogPage;

        return $this;
    }

    /**
     * @param  bool $isShoppingCart
     * @return void
     */
    public function setIsShoppingCart($isShoppingCart)
    {
        $this->isShoppingCart = $isShoppingCart;

        if ($isShoppingCart) {
            $this->_template = 'Revolut_Payment::prbutton/cart.phtml';
        }
    }

    /**
     * Should render or not
     *
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function shouldRender()
    {
        if ($this->getIsCart()) {
            $this->_template = 'Revolut_Payment::prbutton/cart.phtml';
            return true;
        }

        return $this->isCatalogPage;
    }

    /**
     * Render the block if needed
     *
     * @return string
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function _toHtml()
    {
        if (!$this->shouldRender()) {
            return '';
        }

        return parent::_toHtml();
    }
}
