<?php

namespace Revolut\Payment\Block\PaymentRequest;

use Revolut\Payment\Model\Source\Mode;
use Revolut\Payment\Model\ConstantValue;
use Magento\Framework\View\Element\Template;
use Magento\Framework\Registry;
use Magento\Framework\Pricing\PriceCurrencyInterface;

class PaymentRequestButton extends Template
{
    /**
     * @var \Magento\Framework\UrlInterface
     */
    protected $urlBuilder;

    /**
     * @var Registry
     */
    protected $registry;

    /**
     * @var PriceCurrencyInterface
     */
    protected $priceCurrency;

    /**
     * @var \Magento\Checkout\Helper\Data
     */
    protected $checkoutHelper;

    /**
     * @var \Magento\Tax\Helper\Data
     */
    protected $taxHelper;


    /**
     * @var \Revolut\Payment\Helper\ConfigHelper
     */
    protected $configHelper;

    /**
     * @var String
     */
    public $revolutSdkUrl;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    public $request;

    /**
     * @var \Revolut\Payment\Model\Api\RevolutOrderApiService
     */
    public $revolutOrderApiService;

    /**
     * Button constructor.
     *
     * @param Template\Context                                  $context
     * @param \Revolut\Payment\Helper\ConfigHelper              $configHelper
     * @param Registry                                          $registry
     * @param \Magento\Checkout\Helper\Data                     $checkoutHelper
     * @param \Magento\Tax\Helper\Data                          $taxHelper
     * @param \Revolut\Payment\Model\Api\RevolutOrderApiService $revolutOrderApiService
     * @param array                                             $data
     */
    public function __construct(
        Template\Context $context,
        \Revolut\Payment\Helper\ConfigHelper $configHelper,
        Registry $registry,
        \Magento\Checkout\Helper\Data $checkoutHelper,
        \Magento\Tax\Helper\Data $taxHelper,
        \Revolut\Payment\Model\Api\RevolutOrderApiService $revolutOrderApiService,
        array $data = []
    ) {
        parent::__construct($context, $data);

        $this->registry = $registry;
        $this->urlBuilder = $context->getUrlBuilder();
        $this->checkoutHelper = $checkoutHelper;
        $this->taxHelper = $taxHelper;
        $this->configHelper = $configHelper;
        $this->revolutOrderApiService = $revolutOrderApiService;
        $this->getRevolutSdk();
    }
    
    /**
     * @return void
     */
    public function getRevolutSdk()
    {
        $mode = $this->configHelper->getMode() == Mode::PRODUCTION_MODE ? ConstantValue::PROD_MODE : ConstantValue::SANDBOX_MODE;
        $this->revolutSdkUrl = ConstantValue::REVOLUT_SDK_URLS[$mode];
    }

     /**
      * @return string
      */
    public function getStoreCode()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $storeManager = $objectManager->create("\Magento\Store\Model\StoreManagerInterface");
        return $storeManager->getStore()->getCode(); // @phpstan-ignore-line
    }

    /**
     * @param  string $location
     * @return bool
     */
    public function isActiveLocation($location)
    {
        return $this->configHelper->isPaymentRequestButtonAvailableFor($location);
    }

    /**
     * @return int
     */
    public function getProductId()
    {
        $product = $this->registry->registry('product');
        if ($product) {
            return $product->getId();
        }
        return 0;
    }
    
     /**
      * @return mixed
      */
    public function getThemeConfigs()
    {
        return \json_encode($this->configHelper->getPaymentRequestButtonThemeConfigs());
    }

    /**
     * Get Quote
     *
     * @return \Magento\Quote\Model\Quote
     */
    public function getQuote()
    {
        $quote = $this->checkoutHelper->getCheckout()->getQuote();
        if (!$quote->getId()) {
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $quote = $objectManager->create('Magento\Checkout\Model\Session')->getQuote(); // @phpstan-ignore-line
        }

        return $quote;
    }

    /**
     * Get Country Code
     *
     * @return string
     */
    public function getCountry()
    {
        return $this->getQuote()->getBillingAddress()->getCountryId();
    }
}
