<?php

namespace Revolut\Payment\Block\Adminhtml\Order\View\Info;

use Magento\Backend\Block\Template;

/**
 * Class Order
 *
 * @package Revolut\Payment\Block\Adminhtml\Order\View\Info
 */
class Order extends Template
{
    /**
     * @var \Magento\Framework\Registry
     */
    protected $registry;

    /**
     * @var \Revolut\Payment\Model\RevolutOrderFactory
     */
    protected $revolutOrderFactory;

    /**
     * @var \Revolut\Payment\Model\ResourceModel\RevolutOrder
     */
    protected $reRevolutOrderResourceModel;

    /**
     * @var \Revolut\Payment\Helper\DataHelper
     */
    protected $dataHelper;

    /**
     * @var \Revolut\Payment\Helper\Logger
     */
    protected $loggerRevolut;

    /**
     * Order constructor.
     *
     * @param Template\Context                                  $context
     * @param \Magento\Framework\Registry                       $registry
     * @param \Revolut\Payment\Model\RevolutOrderFactory        $revolutOrderFactory
     * @param \Revolut\Payment\Model\ResourceModel\RevolutOrder $reRevolutOrderResourceModel
     * @param \Revolut\Payment\Helper\DataHelper $dataHelper
     * @param \Revolut\Payment\Helper\Logger $loggerRevolut
     * @param array                                             $data
     */
    public function __construct(
        Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Revolut\Payment\Model\RevolutOrderFactory $revolutOrderFactory,
        \Revolut\Payment\Model\ResourceModel\RevolutOrder $reRevolutOrderResourceModel,
        \Revolut\Payment\Helper\DataHelper $dataHelper,
        \Revolut\Payment\Helper\Logger $loggerRevolut,
        array $data = []
    ) {
        $this->registry = $registry;
        $this->dataHelper = $dataHelper;
        $this->loggerRevolut = $loggerRevolut;
        $this->revolutOrderFactory = $revolutOrderFactory;
        $this->reRevolutOrderResourceModel = $reRevolutOrderResourceModel;
        parent::__construct($context, $data);
    }

    /**
     * @return array|mixed|null
     */
    public function getOrderPublicId()
    {
        $order = $this->registry->registry('current_order');
        $incrementId = $order->getIncrementId();
        $revolutOrderModel = $this->revolutOrderFactory->create();
        $this->reRevolutOrderResourceModel->load($revolutOrderModel, $incrementId, 'increment_order_id');
        return $revolutOrderModel->getData('revolut_order_id');
    }
    
    /**
     * @return array|mixed|null
     */
    public function getPaymentInfo()
    {
        try {
            $order = $this->registry->registry('current_order');
            $incrementId = $order->getIncrementId();
            $revolutOrderModel = $this->revolutOrderFactory->create();
            $this->reRevolutOrderResourceModel->load($revolutOrderModel, $incrementId, 'increment_order_id');
            $revolutOrderId = $revolutOrderModel->getData('revolut_order_id');
            $revolutOrder = $this->dataHelper->getRevolutOrder($revolutOrderId);

            if (empty($revolutOrder['payments']) || empty($revolutOrder['payments'][0])) {
                return false;
            }
        
            $paymentData = $revolutOrder['payments'][0];

            if (empty($paymentData['payment_method']) || !isset($paymentData['payment_method']['type']) || $paymentData['payment_method']['type'] != 'CARD' || empty($paymentData['payment_method']['card'])) {
                return false;
            }

            $cardData = $paymentData['payment_method']['card'];

            return $cardData;
        } catch (\Exception $e) {
            return false;
        }
    }
}
