<?php

namespace Revolut\Payment\Api;

interface RevolutOrderApiServiceInterface
{
    /**
     * Returns public_id form Revolut
     *
     * @api
     * @return String public_id form revolut.
     */
    public function createOrder();

    /**
     * Updates total amount on revolut
     *
     * @api
     * @return String.
     */
    public function updateOrder();

    /**
     * Cancels order on revolut
     *
     * @api
     * @return String.
     */
    public function cancelOrder();
    
    /**
     * Registers cashback offer
     *
     * @api
     * @return bool registration result.
     */
    public function registerCashback();
}
