<?php

namespace Revolut\Payment\Api;

interface PaymentRequestButtonServiceInterface
{
    /**
     * Creates card for Express checkout
     *
     * @api
     * @return mixed
     */
    public function addToCart();

    /**
     * Loads shipping options for selected address
     *
     * @api
     * @return mixed
     */
    public function loadShippingOptions();
    
    /**
     * Sets selected shipping option
     *
     * @api
     * @return mixed
     */
    public function setShippingOption();
    
    /**
     * ValidateOrder order
     *
     * @api
     * @return mixed
     */
    public function validateOrder();
    
    /**
     * Process order
     *
     * @api
     * @return mixed
     */
    public function processOrder();
}
